EasyAdmin
=========

EasyAdmin creates administration backends for your Symfony applications with
unprecedented simplicity.

<img src="https://raw.githubusercontent.com/EasyCorp/EasyAdminBundle/master/doc/images/easyadmin-promo.png" alt="Symfony Backends created with EasyAdmin" align="right" />

* [Installation][1]
* [Creating Your First Backend][2]
* [Documentation][3]

**Features**

  * **CRUD** operations on Doctrine entities (create, edit, list, delete).
  * Full-text **search**, **pagination** and column **sorting**.
  * Supports Symfony 4.1 or higher
  * Translated into tens of languages.
  * **Fast**, **simple** and **smart** where appropriate.

**Requirements**

  * Symfony 4.1 or higher applications.
  * Doctrine ORM entities (Doctrine ODM not supported).
  * Entities with composite keys or using inheritance are not supported.

Versions
--------

* [1.x version](https://github.com/EasyCorp/EasyAdminBundle/tree/1.x): no longer
  maintained. Recommended only for legacy projects using a Symfony version prior to 4.1;
* [2.x version](https://github.com/EasyCorp/EasyAdminBundle/tree/2.x): the current
  stable version. Recommended for all projects using Symfony 4.1 or newer;
* [3.x version](https://github.com/EasyCorp/EasyAdminBundle/tree/master): it's
  still in early development. Don't use it in any project yet.

Demo Application
----------------

[easy-admin-demo](https://github.com/javiereguiluz/easy-admin-demo) is a complete
Symfony application created to showcase EasyAdmin features.

License
-------

This software is published under the [MIT License](LICENSE.md)

[1]: https://symfony.com/doc/current/bundles/EasyAdminBundle/book/installation.html
[2]: https://symfony.com/doc/current/bundles/EasyAdminBundle/book/your-first-backend.html
[3]: https://symfony.com/doc/current/bundles/EasyAdminBundle
