<?php

namespace App\Controller;

use App\Entity\Contact;
use App\Model\Type;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Swift_Mailer;
use Swift_Message;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Twig\Template;

class WebController extends AbstractController {

    /**
     * @Route("/", name="web_home")
     */
    public function index() {

        $em = $this->getDoctrine()->getManager();
        $overview = $em->getRepository('App\Entity\Services\Overview')->findBy([
            'enable' => true,
        ]);

        $about = $em->getRepository('App\Entity\About')->findAll();

        return $this->render('web/index.html.twig', [
                    'controller_name' => 'WebController',
                    'overview' => $overview,
                    'about' => $about,
        ]);
    }

    /**
     * @Route("/about", name="web_about")
     */
    public function about() {
        $em = $this->getDoctrine()->getManager();
        $about = $em->getRepository('App\Entity\About')->findAll();
        return $this->render('web/about.html.twig', [
                    'controller_name' => 'WebController',
                    'about' => $about,
        ]);
    }

    /**
     * @Route("/contact", name="web_contact")
     * @Method("GET")
     */
    public function contact(Request $request, Swift_Mailer $mailer) {

        //        $contactForm = $this->createForm(ContactType::class);
        $contact = new Contact();
//        $contact->setEmail('');
//        $contact->setMessage('');
        $contactForm = $this->createFormBuilder($contact)
                ->add('fullname')
                ->add('phone')
                ->add('email', EmailType::class)
                ->add('message')
                ->add('submit', SubmitType::class, array('label' => 'Send Message'))
                ->getForm();

        $contactForm->handleRequest($request);

        if ($contactForm->isSubmitted() && $contactForm->isValid()) {
            $this->addFlash("success", "Hello " . $contact->fullname . "! " . "Your Message has been send Succesfully. Thanks!");

            //Save Data in database
            $em = $this->getDoctrine()->getManager();
            $em->persist($contact);
            $em->flush();

            $notification = (new Swift_Message('You got e-mail from SoftDro!'))
//                    ->setSubject($contact->message)
                    ->setFrom('noreply.softdro@gmail.com')
                    ->setTo('softdro@yahoo.com')
                    ->setBody($this->renderView('email/emailMessage.html.twig', array(
                        'name' => $contact->fullname,
                        'message' => $contact->message,
                        'email' => $contact->email,
                        'phone' => $contact->phone,
                    )), 'text/html');
//        $this->get('mailer')->send($notification);
            $mailer->send($notification);


            return $this->redirectToRoute('web_contact');
        }

        return $this->render('web/contact.html.twig', [
                    'controller_name' => 'WebController',
                    'contactForm' => $contactForm->createView()
        ]);
    }

    /**
     * @Route("/clients", name="web_clients")
     */
    public function clients() {
        return $this->render('web/clients.html.twig', [
                    'controller_name' => 'WebController',
        ]);
    }

    /**
     * @Route("/gallery", name="web_gallery")
     */
    public function gallery() {
        return $this->render('web/gallery.html.twig', [
                    'controller_name' => 'WebController',
        ]);
    }

    /**
     * @Route("/partner", name="web_partner")
     */
    public function partner() {
        return $this->render('web/partner.html.twig', [
                    'controller_name' => 'WebController',
        ]);
    }

    /**
     * @Route("/services/exportImport", name="web_exportImport")
     */
    public function exportImport() {

        $em = $this->getDoctrine()->getManager();
        $exportImport = $em->getRepository('App\Entity\Services\Product')->findBy([
            'type' => Type::PAGE_TYPE_EXPORTIMPORT,
            'enable' => true
        ]);

        return $this->render('services/exportImport.html.twig', [
                    'controller_name' => 'WebController',
                    'exportImport' => $exportImport
        ]);
    }

    /**
     * @Route("/services/boatSupply", name="web_boatSupply")
     */
    public function Boat() {

        $em = $this->getDoctrine()->getManager();
        $boat = $em->getRepository('App\Entity\Services\Product')->findBy([
            'type' => Type::PAGE_TYPE_BOAT_SUPPLY,
            'enable' => true
        ]);

        return $this->render('services/boat.html.twig', [
                    'controller_name' => 'WebController',
                    'boat' => $boat
        ]);
    }

    /**
     * @Route("/services/marinEngineSupply", name="web_marinEngineSupply")
     */
    public function robotics() {

        $em = $this->getDoctrine()->getManager();
        $marinEngineSupply = $em->getRepository('App\Entity\Services\Product')->findBy([
            'type' => Type::PAGE_TYPE_MARINE_ENGINE_SUPPLY,
            'enable' => true
        ]);

        return $this->render('services/marinEngineSupply.html.twig', [
                    'controller_name' => 'WebController',
                    'marinEngineSupply' => $marinEngineSupply
        ]);
    }

    /**
     * @Route("/services/marinPartsSupply", name="web_marinPartsSupply")
     */
    public function secure() {

        $em = $this->getDoctrine()->getManager();
        $marinPartsSupply = $em->getRepository('App\Entity\Services\Product')->findBy([
            'type' => Type::PAGE_TYPE_MARINE_PARTS_SUPPLY,
            'enable' => true
        ]);

        return $this->render('services/marinPartsSupply.html.twig', [
                    'controller_name' => 'WebController',
                    'marinPartsSupply' => $marinPartsSupply
        ]);
    }

    /**
     * @Route("/footer", name="footer")
     */
    public function footer() {

        $em = $this->getDoctrine()->getManager();
        $footer = $em->getRepository('App\Entity\Footer')->findAll();

        return $this->render('web/_footer.html.twig', [
                    'footer' => $footer
        ]);
    }

}
