<?php

namespace App\Admin\Services;

use App\Model\Type;
use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Show\ShowMapper;
use Sonata\Form\Type\DatePickerType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Vich\UploaderBundle\Form\Type\VichImageType;

class ProductAdmin extends AbstractAdmin {

    protected $parentAssociationMapping = 'services_product';
    protected $baseRoutePattern = 'services_product';

    protected function configureFormFields(FormMapper $formMapper) {
        $formMapper
                ->with('Product Info', array('class' => 'col-md-6'))
                ->add('type', ChoiceType::class, [
                    'label' => 'Page Name',
                    'placeholder' => 'Select Page',
                    'choices' => Type::getPageTypes()
                ])
                ->add('name', TextType::class, [
                    'label' => 'Product Name',
                    'required' => false
                ])
                ->add('description', TextareaType::class, [
                    'required' => false,
                    'attr' => [
                        'style' => 'max-width: 100%;'
                    ]
                ])
//                ->add('specifications')
                ->add('specifications', CKEditorType::class,[
                    'required' => false
                ])
                ->end()
                ->with('File Info', array('class' => 'col-md-6'))
                ->add('imageFile', VichImageType::class, [
                    'label' => 'Image',
                    'required' => false,
                    'allow_delete' => true,
                    'download_label' => true,
                    'download_uri' => false,
                    'image_uri' => true,
                    'asset_helper' => false,
                    'attr' => [
                        'style' => 'width: 200px;'
                    ]
                ])
                ->add('img_align', ChoiceType::class, [
                    'label' => 'Image Align',
                    'placeholder' => 'Select Align',
                    'choices' => Type::getImageAlignTypes()
                ])
                ->add('specificationFile', VichImageType::class, [
                    'label' => 'Specications File',
                    'required' => false,
                    'allow_delete' => true,
                    'download_label' => false,
                    'download_uri' => false,
                    'image_uri' => false,
                    'asset_helper' => false,
                ])
                ->add('enable')
                ->end()
        ;
    }

    protected function configureDatagridFilters(DatagridMapper $datagridMapper) {
        $datagridMapper
                ->add('type')
                ->add('name',null,[
                    'lable' => 'Product Name',
//                    'show_filter'=>true
                ])
                ->add('createdAt', 'doctrine_orm_date', [
                    'field_type'=> DatePickerType::class,
                    'label' => 'Created Date'
                ])
                ->add('enable',null,[
//                    'show_filter'=>true
                ])
        ;
    }

    protected function configureListFields(ListMapper $listMapper) {
        $listMapper
                ->addIdentifier('type', null, [
                    'label' => "Page Name"
                ])
                ->add('name', null, [
                    'label' => 'Product Name',
                    'editable' => true
                ])
                ->add('description', null, [
                    'header_style' => 'width: 20%',
                    'collapse' => [
                        'height' => '60px',
                        'more' => 'See More'
                    ]
                ])
                ->add('specifications', null, [
                    'template' => 'Admin\specifications.html.twig',
                    'header_style' => 'width: 20%',
                    'collapse' => [
                        'height' => '60px',
                        'more' => 'See More'
                    ]
                ])
                ->add('imageName', 'string', [
                    'template' => 'Admin\list_image.html.twig'
                ])
                ->add('img_align', null, [
                    'label' => "Image Align"
                ])
                ->add('createdAt')
                ->add('enable', null, [
                    'editable' => true
                ])
                ->add('_action', null, [
                    'actions' => [
                        'show' => [],
                        'edit' => [],
                        'delete' => [],
                    ]
                ])
        ;
    }

    protected function configureShowFields(ShowMapper $showMapper) {
        $showMapper
                ->add('id')
                ->add('type', null, [
                    'label' => "Page Name"
                ])
                ->add('name', null, [
                    'label' => 'Product Name'
                ])
                ->add('description')
                ->add('specifications', null, [
                    'template' => 'Admin\specifications.html.twig'
                ])
                ->add('imageName', null, [
                    'template' => 'Admin\show_image.html.twig'
                ])
                ->add('img_align', null, [
                    'label' => "Image Align"
                ])
                ->add('more_details')
                ->add('createdAt')
//                ->add('updatedAt')
                ->add('enable')
        ;
    }

}
