<?php

declare(strict_types=1);

namespace App\Admin\Services;

use App\Model\Type;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Vich\UploaderBundle\Form\Type\VichImageType;

final class OverviewAdmin extends AbstractAdmin {

    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void {
        $datagridMapper
                ->add('type')
                ->add('enable')
        ;
    }

    protected function configureListFields(ListMapper $listMapper): void {
        $listMapper
                ->add('type')
                ->add('service_overview', null, [
                    'header_style' => 'width: 25%',
                    'collapse' => [
                        'height' => '60px',
                        'more' => 'See More'
                    ]
                ])
                ->add('imageName', 'string', [
                    'template' => 'Admin\slider_list_image.html.twig'
                ])
                ->add('createdAt')
                ->add('enable',null,[
                    'editable' => true
                ])
                ->add('_action', null, [
                    'actions' => [
                        'show' => [],
                        'edit' => [],
                        'delete' => [],
                    ],
        ]);
    }

    protected function configureFormFields(FormMapper $formMapper): void {
        $formMapper
                ->add('type', ChoiceType::class, [
                    'label' => 'Page Name',
                    'placeholder' => 'Select Page',
                    'choices' => Type::getPageTypes()
                ])
                ->add('service_overview', TextareaType::class)
                ->add('imageFile', VichImageType::class, [
                    'label' => 'Slider Image',
                    'required' => false,
                    'allow_delete' => true,
                    'download_label' => true,
                    'download_uri' => false,
                    'image_uri' => true,
                    'asset_helper' => false,
                    'attr' => [
                        'style' => 'width: 200px;'
                    ]
                ])
                ->add('enable')
        ;
    }

    protected function configureShowFields(ShowMapper $showMapper): void {
        $showMapper
                ->add('id')
                ->add('type')
                ->add('service_overview')
                ->add('imageName', null, [
                    'template' => 'Admin\slider_show_image.html.twig'
                ])
                ->add('createdAt')
                ->add('enable')
        ;
    }

}
