<?php

declare(strict_types=1);

namespace App\Admin;

use App\Model\Type;
use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

final class FooterAdmin extends AbstractAdmin {

    protected $parentAssociationMapping = 'footer';
    protected $baseRoutePattern = 'footer';

    protected function configureRoutes(RouteCollection $collection) {
//        $collection->remove('create');
    }

    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void {
        $datagridMapper
                ->add('country', null, [
                    'label' => 'Country'
                ])
                ->add('phone')
                ->add('email')
        ;
    }

    protected function configureListFields(ListMapper $listMapper): void {
        $listMapper
                ->add('country', null, [
                    'label' => 'Country'
                ])
                ->add('phone')
                ->add('email')
                ->add('address', null, [
                    'template' => 'Admin\list_footer.html.twig',
                    'header_style' => 'width: 20%',
                    'collapse' => [
                        'height' => '60px',
                        'more' => 'See More'
                    ]
                ])
                ->add('_action', null, [
                    'actions' => [
                        'show' => [],
                        'edit' => [],
                        'delete' => [],
                    ],
        ]);
    }

    protected function configureFormFields(FormMapper $formMapper): void {
        $formMapper
                ->with('Location', ['class' => 'col-md-6'])
                ->add('country', ChoiceType::class, [
                    'label' => 'Country Name',
                    'placeholder' => 'Select Country',
                    'choices' => Type::getCountryTypes()
                ])
                ->add('address', CKEditorType::class)
                ->end()
                ->with('Contact', ['class' => 'col-md-6'])
                ->add('phone', TextType::class)
                ->add('email', TextType::class)
                ->end()

        ;
    }

    protected function configureShowFields(ShowMapper $showMapper): void {
        $showMapper
                ->add('country', null, [
                    'label' => 'Country'
                ])
                ->add('phone')
                ->add('email')
                ->add('address')
        ;
    }

}
