<?php

declare(strict_types=1);

namespace App\Admin;

use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Show\ShowMapper;
use Sonata\Form\Type\DatePickerType;
use Sonata\AdminBundle\Route\RouteCollection;

final class ContactAdmin extends AbstractAdmin {

    protected $parentAssociationMapping = 'contact';
    protected $baseRoutePattern = 'contact';

    protected function configureRoutes(RouteCollection $collection) {
        $collection->remove('create');
    }

    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void {
        $datagridMapper
                ->add('fullname')
                ->add('phone')
                ->add('email')
                ->add('message')
                ->add('date_time', 'doctrine_orm_date', [
                    'field_type' => DatePickerType::class,
                    'label' => 'Date'
                ])
        ;
    }

    protected function configureListFields(ListMapper $listMapper): void {
        $listMapper
                ->add('fullname')
                ->add('phone')
                ->add('email')
                ->add('message')
                ->add('date_time')
                ->add('_action', null, [
                    'actions' => [
                        'show' => [],
//                        'edit' => [],
                        'delete' => [],
                    ],
        ]);
    }

    protected function configureFormFields(FormMapper $formMapper): void {
        $formMapper
                ->add('fullname')
                ->add('phone')
                ->add('email')
                ->add('message')
                ->add('date_time')
        ;
    }

    protected function configureShowFields(ShowMapper $showMapper): void {
        $showMapper
                ->add('id')
                ->add('fullname')
                ->add('phone')
                ->add('email')
                ->add('message')
                ->add('date_time')
        ;
    }

}
