<?php

declare(strict_types=1);

namespace App\Admin;

use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;

final class AboutAdmin extends AbstractAdmin {

    protected $parentAssociationMapping = 'about';
    protected $baseRoutePattern = 'about';

    protected function configureRoutes(RouteCollection $collection) {
//        $collection->remove('create');
    }

    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void {
        $datagridMapper
//                ->add('details', TextareaType::class)
        ;
    }

    protected function configureListFields(ListMapper $listMapper): void {
        $listMapper
                ->add('details')
                ->add('_action', null, [
                    'actions' => [
                        'show' => [],
                        'edit' => [],
                        'delete' => [],
                    ],
        ]);
    }

    protected function configureFormFields(FormMapper $formMapper): void {
        $formMapper
                ->add('details',CKEditorType::class)
        ;
    }

    protected function configureShowFields(ShowMapper $showMapper): void {
        $showMapper
                ->add('details')
        ;
    }

}
